IF EXISTS (SELECT 1 FROM sys.objects WHERE [name] = N'TRG_PDV_VD_DEV_EST_PROD_IMP_PEND_NF_ADD' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[TRG_PDV_VD_DEV_EST_PROD_IMP_PEND_NF_ADD];
END;
GO

CREATE TRIGGER [dbo].[TRG_PDV_VD_DEV_EST_PROD_IMP_PEND_NF_ADD] ON [dbo].[PDV_VD_DEV_EST_PROD_IMP] FOR INSERT AS
BEGIN 
	
	IF EXISTS (SELECT conf.CD_EMP 
			   FROM PRC_FILIAL_CONFIG conf INNER JOIN INSERTED i ON
					conf.CD_EMP			= i.CD_EMP
					AND conf.CD_FILIAL	= i.CD_FILIAL
			   WHERE conf.CD_CHAVE = 'flag_nf_devo_requis'
					AND ISNULL(conf.VALOR, 0) = 1)
					
		BEGIN
		    -- ESTRUTURA CONDICIONAL INCLUSA EM : 29/08/2022, para o atendimento do CHAMADO: FARMAGOI-32280 ( SUBTAREFA: 32303 )  , RFS
			-- PROPSITO: TRATAR A MARCAO DA FLAG:  FLAG_BLOQUEIA_REQ_PENDENTE_MANIP_SERV, ELA IR DEFINIR A INCLUSO (OU NO) DE REGISTRO DE REQUISIO DE PENDNCIA , PORM S A MARCAO DA FLAG POR SI S NO FUNCIONAR PORQU AO MARC-LA TRAVARIA A INCLUSO PA
			--RA TODOS OS "PRODUTOS" ;
			IF EXISTS (SELECT conf.CD_EMP 
			   			   FROM PRC_FILIAL_CONFIG conf INNER JOIN INSERTED i ON
							    conf.CD_EMP			= i.CD_EMP
							    AND conf.CD_FILIAL	= i.CD_FILIAL
			   		       WHERE conf.CD_CHAVE = 'FLAG_BLOQUEIA_REQ_PENDENTE_MANIP_SERV'
							    AND ISNULL(conf.VALOR, 0) = 1)
					BEGIN		
						-- ESTRUTURA CONDICIONAL INCLUSA EM : 29/08/2022, para o atendimento do CHAMADO: FARMAGOI-32280 ( SUBTAREFA: 32303 )  , RFS	
						-- PROPSITO:  TRATAR A UTILIZAO DA FLAG (OU CAMPO): TP_PROD (10 OU 11) DA TABELA: EST_PROD_CPL PARA ESPECIFICAR: "SERVIOS" OU "MANIPULADO".
						IF NOT EXISTS (SELECT	est.CD_EMP, 
						                        est.CD_PROD , 
												est.CD_FILIAL, 
												est.TP_PROD
									   FROM INSERTED i INNER JOIN EST_PROD_CPL est ON
												i.CD_EMP		= est.CD_EMP
												AND i.CD_FILIAL = est.CD_FILIAL
												AND i.CD_PROD	= est.CD_PROD
												AND est.TP_PROD IN (10, 11))	
							    BEGIN
					                            -- ROTINA DE INSERT QUE J EXISTIA ANTES DE: 29/08/2022, para o atendimento do CHAMADO: FARMAGOI-32280 ( SUBTAREFA: 32303 )  , RFS	
												INSERT INTO PDV_VD_DEV_EST_PROD_IMP_PEND_NF 
													(CD_EMP, CD_FILIAL, CD_VD, CD_IMP, CD_PROD, DT_CAD,CD_IT)
						
													SELECT	i.CD_EMP, 
															i.CD_FILIAL, 
															i.CD_VD, 
															i.CD_IMP, 
															i.CD_PROD, 
															imp.DT_CAD,
															i.CD_IT
													FROM INSERTED i INNER JOIN EST_PROD_IMP imp ON
															i.CD_EMP		= imp.CD_EMP
															AND i.CD_FILIAL = imp.CD_FILIAL
															AND i.CD_IMP	= imp.CD_IMP
															AND i.CD_PROD	= imp.CD_PROD
															
								END	
                    END		
			ELSE
			        -- O ELSE VAI FUNCIONAR TANTO PARA OUTROS CLIENTES (SEM SER ESTRELA) QUANTO PARA AS FILIAIS DA ESTRELA SEM O FLAG: FLAG_BLOQUEIA_REQ_PENDENTE_MANIP_SERV MARCADO;
					BEGIN		
					
						-- ROTINA DE INSERT QUE J EXISTIA ANTES DE: 29/08/2022, para o atendimento do CHAMADO: FARMAGOI-32280 ( SUBTAREFA: 32303 )  , RFS	
						INSERT INTO PDV_VD_DEV_EST_PROD_IMP_PEND_NF 
							   (CD_EMP, CD_FILIAL, CD_VD, CD_IMP, CD_PROD, DT_CAD,CD_IT)
						
								SELECT	i.CD_EMP, 
										i.CD_FILIAL, 
										i.CD_VD, 
										i.CD_IMP, 
										i.CD_PROD, 
										imp.DT_CAD,
										i.CD_IT
								FROM INSERTED i INNER JOIN EST_PROD_IMP imp ON
										i.CD_EMP		= imp.CD_EMP
										AND i.CD_FILIAL = imp.CD_FILIAL
										AND i.CD_IMP	= imp.CD_IMP
										AND i.CD_PROD	= imp.CD_PROD								
                    END								
		END			
END

GO

ALTER TABLE [dbo].[PDV_VD_DEV_EST_PROD_IMP] ENABLE TRIGGER [TRG_PDV_VD_DEV_EST_PROD_IMP_PEND_NF_ADD]
GO


